
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 07 10:08:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A facade for all QA Middleware ATPs
   *
   *  \version MW_ATP_main.c#1:csrc:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/***** Include Files **************/

#include "CRYS.h"

#include "MW_ATP_defines.h"
#include "MW_ATP_define_flags.h"
#include "MW_ATP_UTIL_funcs.h"
#include "DX_VOS_Stdio.h"
#include "CRYS_ATP_TST_main.h"
//#include "ExtApp_ATP_main.h"

/******** Defines ************/

#ifndef DX_NO_SST_SUPPORT
    extern DxError_t SST_ATP_menu( void );
    extern DxError_t SST_ATP_TST_Run_All_ATP_Tests( void );
#endif
#ifndef DX_NO_KMNG_SUPPORT
    extern DxError_t KMNG_ATP_menu( void );
    extern DxError_t KMNG_ATP_TST_Run_All_ATP_Tests( void ); 
#endif
#ifndef DX_NO_TLK_ODRM_SUPPORT
    extern DxError_t ODRM_TLK_ATP_menu( void );
    extern DxError_t TST_ATP_TLK_ODRM_Run_All_Tests( void );
#endif
#ifndef DX_NO_TLK_CERT_SUPPORT
	extern DxError_t CERT_TLK_ATP_menu( void );
	extern DxError_t TST_ATP_TLK_CERT_Run_All_Tests( void );
#endif
#ifndef DX_NO_MNG_SUPPORT
    extern DxError_t MNG_ATP_menu(void);
#endif
#ifndef DX_NO_WMDRM_SUPPORT
    extern DxError_t WMDRM_TST_menu(DxUint32_t argc, DxChar* argv[]);
#endif
#ifndef DX_NO_ExtAPP_SUPPORT
    extern DxError_t Ext_ATP_menu (void);
#endif
#ifndef DX_NO_TLK_SCLK_SUPPORT
	extern DxError_t TLK_SCLK_ATP_menu(void);
  extern DxError_t TST_ATP_TLK_SCLK_Run_All_Tests( void );
#endif

#ifndef DX_NO_TLK_SEC_RO_HANDLING_SUPPORT
	extern DxError_t  ODRM_SecROHandling_ATP_menu(void);
    extern DxError_t  TST_ATP_SecRO_ODRM_Run_All_Tests(void);
#endif
/******** Enums ************/
/******** Typedefs ***********/
/******** Global Data **********/
/******** Private Functions ******/

/*****************************************************************************
* Function Name:                                                           
*  MW_ATP_TST_RunAllATPs      
*  
* Inputs:
*  TST_KeyGeneration_flag - A parameter defining if to run the test with 
*                           internal key generation TST_INTERNAL_KG - Run the 
*                           test with internal key generation and external keys
*							TST_NO_INTERNAL_KEYGEN  - Run the test with external 
*							key only - NO keyGen
*
* Outputs:
*  DxError_t - Function error return
*
* Description:                                                                 
*  This function runs all the ATPs tests
*  
*******************************************************************************/

DxError_t MW_ATP_TST_RunAllATPs(DxUint32_t TST_KeyGeneration_flag)
{
    DxError_t TST_ATP_Error = DX_SUCCESS;
    
    DxUint32_t TST_FailedTestsFlags = 0;
    /* a bit-map with flags of failure of every ATP test */
    
    DxUint32_t TST_TestsNum = 0;
    /* current test index */
    
    TST_ATP_Error = CRYS_ATP_TST_RunAllAcceptance_tests(TST_KeyGeneration_flag);
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;

#ifndef DX_NO_SST_SUPPORT
    TST_ATP_Error = SST_ATP_TST_Run_All_ATP_Tests();
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
#endif

#ifndef DX_NO_KMNG_SUPPORT
    TST_ATP_Error = KMNG_ATP_TST_Run_All_ATP_Tests();
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
#endif

#ifndef DX_NO_TLK_ODRM_SUPPORT
    TST_ATP_Error = TST_ATP_TLK_ODRM_Run_All_Tests();
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
#endif

#ifndef DX_NO_TLK_CERT_SUPPORT
	TST_ATP_Error = TST_ATP_TLK_CERT_Run_All_Tests();
	TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
	TST_TestsNum++;
#endif

#ifndef DX_NO_TLK_SCLK_SUPPORT
	TST_ATP_Error = TST_ATP_TLK_SCLK_Run_All_Tests();
	TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
	TST_TestsNum++;
#endif	

#ifndef DX_NO_TLK_SEC_RO_HANDLING_SUPPORT
    TST_ATP_Error = TST_ATP_SecRO_ODRM_Run_All_Tests();
    TST_FailedTestsFlags |= (TST_ATP_Error!=DX_SUCCESS) << TST_TestsNum;
    TST_TestsNum++;
#endif

    /*Check if all tests passed*/
    if (TST_FailedTestsFlags > 0)
    {
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!       SOME ATP TESTS FAILED    :@     0x%03X   !!!!!!!!!!\n",TST_FailedTestsFlags));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    }
    else
    {
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n \n#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~      ALL OF THE MW ACCEPTANCE TESTS PASSED  :)  :P  :D    ~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));
        ATP_LOG_TST_PRINT((MW_ATP_MSG,"#'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`'`~.,.~`#\n"));					
    }	
    return TST_ATP_Error;
		
}

/******** Public Functions *********/

 /*****************************************************************************
* Function Name:                                                           
*  MW_ATP_TST_RunAllATPs      
*  
* Inputs:
*  
*
* Outputs:
*  
*
* Description:                                                                 
*  This is the main entry point to the MW tests 
*  
*******************************************************************************/
 #if MW_QA_ATP_TST

 int main(int argc, char *argv[])

 #else

 DxError_t MW_ATP_main (int argc, char *argv[])

 #endif  /* MW_QA_ATP_TST */
 {

    /* Handle Command Line Arguments */
    TST_ATP_Error = MW_ATP_UTIL_ParseArgs(argc,argv);
    TST_ATP_Error = TST_ATP_CheckErrorReturn(TST_ATP_Error,
                                             "MW_ATP_UTIL_ParseArgs",
                                             "!!!!!!!!!",
                                             "!!!!!!!!!");
    MW_ATP_RETURN_ON_FAILURE(TST_ATP_Error);
    
    /* Init CRYS */
    TST_ATP_Error = MW_ATP_UTIL_Init_CRYS();
    TST_ATP_Error = TST_ATP_CheckErrorReturn(TST_ATP_Error,
                                             "MW_ATP_UTIL_Init_CRYS",
                                             "!!!!!!!!!",
                                             "!!!!!!!!!");
    MW_ATP_RETURN_ON_FAILURE(TST_ATP_Error);

    
    if (TST_IsInteractive == DX_TRUE)
    {
        MW_ATP_TST_RunAllATPs(TST_UseInternalKG);
    }
    else
    {
        DxUint8_t Var;
        do
        {
	        do
	        {
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n           -- DISCRETIX LTD 2007 --              "));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       -- Acceptance tests Ver -  06.03.00 --        "));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n---[ Main Tests Menu ]-------------------------------"));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));

                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - CRYS          Tests                          "));
                
                #ifndef DX_NO_SST_SUPPORT
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - SST           Tests                          "));
                #endif
                #ifndef DX_NO_KMNG_SUPPORT
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - KMNG          Tests                          "));
                #endif
                #ifndef DX_NO_TLK_ODRM_SUPPORT
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [4] - TLK_ODRM      Tests                          "));
                #endif
				        #ifndef DX_NO_TLK_CERT_SUPPORT
				        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [5] - TLK_CERT      Tests                  "));
				        #endif				
                #ifndef DX_NO_MNG_SUPPORT
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [6] - MNG           Tests                          "));
                #endif
                #ifndef DX_NO_WMDRM_SUPPORT
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [7] - WMDRM         Tests                          "));
                #endif
                #ifndef DX_NO_ExtAPP_SUPPORT
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [8] - External application         Tests           "));                
                #endif
				#ifndef DX_NO_TLK_SCLK_SUPPORT
				ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [9] - TLK_SCLK      Tests                          "));				
				#endif
				#ifndef DX_NO_TLK_SEC_RO_HANDLING_SUPPORT
				ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [A] - TLK_SEC_RO_HANDLING      Tests               "));				
				#endif

                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run all(but MNG) Acceptance Tests             "));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       [with internal KeyGeneration for RSA & ECC]   "));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [S] - Run all(but MNG) Acceptance Tests             "));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       [without internal KeyGeneration for RSA & ECC]"));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End of tests                                  "));
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-------------------------------------------------\n\n"));
                
                GET_NON_WHITE_SPACE_CHAR(Var);
                
                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Test = %c\n",Var));
                if (Var<='Z')
                    break;
                else
                {
                        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
                }
            }while(1);

            switch(Var)
            {
                case '1':
                        CRYS_ATP_menu();
                        break;
                #ifndef DX_NO_SST_SUPPORT
                case '2':
                        SST_ATP_menu();
                        break;
                #endif
                #ifndef DX_NO_KMNG_SUPPORT
                case '3':
                        KMNG_ATP_menu();
                        break;
                #endif
                #ifndef DX_NO_TLK_ODRM_SUPPORT
                case '4':
                        ODRM_TLK_ATP_menu();
                        break;
                #endif
				#ifndef DX_NO_TLK_CERT_SUPPORT
				case '5':
						CERT_TLK_ATP_menu();
						break;
				#endif
                #ifndef DX_NO_MNG_SUPPORT
                case '6':   
                        MNG_ATP_menu();
                        break;
                #endif
                #ifndef DX_NO_WMDRM_SUPPORT
                case '7':   
                        WMDRM_TST_menu(0,DX_NULL);
                        break;
                #endif
                #ifndef DX_NO_ExtAPP_SUPPORT
                case '8':
                        EXTApp_ATP_menu();
                        break;
                #endif
				
				#ifndef DX_NO_TLK_SCLK_SUPPORT
				case '9':
						TLK_SCLK_ATP_menu();
						break;
				#endif
				#ifndef DX_NO_TLK_SEC_RO_HANDLING_SUPPORT
				case 'A':
						ODRM_SecROHandling_ATP_menu();
						break;
				#endif
                case 'T':
                        MW_ATP_TST_RunAllATPs(TST_INTERNAL_KG);
                        break;
                case 'S':
                        MW_ATP_TST_RunAllATPs(TST_NO_INTERNAL_KEYGEN);
                        break;
                case 'Z':
                        DX_VOS_Printf("\n End of MW ATP tests \n");
                        break ;
                        
                default:
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n* Error in test selection [%c]ASCII(%d)\n",Var,(DxUint32_t)Var));
            }
            if(Var =='Z')
            break;
        }while (1);
    }
    
    return TST_ATP_Error;
    
 }/* End of MW_QA_ATP_TST*/

